<?php

namespace App\Test\Controller;

use App\Entity\Person;
use App\Repository\PersonRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class PersonControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private PersonRepository $repository;
    private string $path = '/person/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->repository = (static::getContainer()->get('doctrine'))->getRepository(Person::class);

        foreach ($this->repository->findAll() as $object) {
            $this->repository->remove($object, true);
        }
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Person index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $originalNumObjectsInRepository = count($this->repository->findAll());

        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'person[firstName]' => 'Testing',
            'person[lastName]' => 'Testing',
            'person[civility]' => 'Testing',
            'person[niu]' => 'Testing',
            'person[dateOfBirth]' => 'Testing',
            'person[placeOfBirth]' => 'Testing',
            'person[fatherLastName]' => 'Testing',
            'person[fatherFirstName]' => 'Testing',
            'person[motherFirstName]' => 'Testing',
            'person[motherLastName]' => 'Testing',
            'person[email]' => 'Testing',
            'person[phone]' => 'Testing',
            'person[typeOfIdentificationDocument]' => 'Testing',
            'person[identificationDocumentNumber]' => 'Testing',
            'person[dateOfIssue]' => 'Testing',
            'person[pictureFrontOfIdentificationDocument]' => 'Testing',
            'person[pictureBackOfIdentificationDocument]' => 'Testing',
            'person[stop]' => 'Testing',
            'person[dateCreated]' => 'Testing',
        ]);

        self::assertResponseRedirects('/person/');

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new Person();
        $fixture->setFirstName('My Title');
        $fixture->setLastName('My Title');
        $fixture->setCivility('My Title');
        $fixture->setNiu('My Title');
        $fixture->setDateOfBirth('My Title');
        $fixture->setPlaceOfBirth('My Title');
        $fixture->setFatherLastName('My Title');
        $fixture->setFatherFirstName('My Title');
        $fixture->setMotherFirstName('My Title');
        $fixture->setMotherLastName('My Title');
        $fixture->setEmail('My Title');
        $fixture->setPhone('My Title');
        $fixture->setTypeOfIdentificationDocument('My Title');
        $fixture->setIdentificationDocumentNumber('My Title');
        $fixture->setDateOfIssue('My Title');
        $fixture->setPictureFrontOfIdentificationDocument('My Title');
        $fixture->setPictureBackOfIdentificationDocument('My Title');
        $fixture->setStop('My Title');
        $fixture->setDateCreated('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Person');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new Person();
        $fixture->setFirstName('My Title');
        $fixture->setLastName('My Title');
        $fixture->setCivility('My Title');
        $fixture->setNiu('My Title');
        $fixture->setDateOfBirth('My Title');
        $fixture->setPlaceOfBirth('My Title');
        $fixture->setFatherLastName('My Title');
        $fixture->setFatherFirstName('My Title');
        $fixture->setMotherFirstName('My Title');
        $fixture->setMotherLastName('My Title');
        $fixture->setEmail('My Title');
        $fixture->setPhone('My Title');
        $fixture->setTypeOfIdentificationDocument('My Title');
        $fixture->setIdentificationDocumentNumber('My Title');
        $fixture->setDateOfIssue('My Title');
        $fixture->setPictureFrontOfIdentificationDocument('My Title');
        $fixture->setPictureBackOfIdentificationDocument('My Title');
        $fixture->setStop('My Title');
        $fixture->setDateCreated('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'person[firstName]' => 'Something New',
            'person[lastName]' => 'Something New',
            'person[civility]' => 'Something New',
            'person[niu]' => 'Something New',
            'person[dateOfBirth]' => 'Something New',
            'person[placeOfBirth]' => 'Something New',
            'person[fatherLastName]' => 'Something New',
            'person[fatherFirstName]' => 'Something New',
            'person[motherFirstName]' => 'Something New',
            'person[motherLastName]' => 'Something New',
            'person[email]' => 'Something New',
            'person[phone]' => 'Something New',
            'person[typeOfIdentificationDocument]' => 'Something New',
            'person[identificationDocumentNumber]' => 'Something New',
            'person[dateOfIssue]' => 'Something New',
            'person[pictureFrontOfIdentificationDocument]' => 'Something New',
            'person[pictureBackOfIdentificationDocument]' => 'Something New',
            'person[stop]' => 'Something New',
            'person[dateCreated]' => 'Something New',
        ]);

        self::assertResponseRedirects('/person/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getFirstName());
        self::assertSame('Something New', $fixture[0]->getLastName());
        self::assertSame('Something New', $fixture[0]->getCivility());
        self::assertSame('Something New', $fixture[0]->getNiu());
        self::assertSame('Something New', $fixture[0]->getDateOfBirth());
        self::assertSame('Something New', $fixture[0]->getPlaceOfBirth());
        self::assertSame('Something New', $fixture[0]->getFatherLastName());
        self::assertSame('Something New', $fixture[0]->getFatherFirstName());
        self::assertSame('Something New', $fixture[0]->getMotherFirstName());
        self::assertSame('Something New', $fixture[0]->getMotherLastName());
        self::assertSame('Something New', $fixture[0]->getEmail());
        self::assertSame('Something New', $fixture[0]->getPhone());
        self::assertSame('Something New', $fixture[0]->getTypeOfIdentificationDocument());
        self::assertSame('Something New', $fixture[0]->getIdentificationDocumentNumber());
        self::assertSame('Something New', $fixture[0]->getDateOfIssue());
        self::assertSame('Something New', $fixture[0]->getPictureFrontOfIdentificationDocument());
        self::assertSame('Something New', $fixture[0]->getPictureBackOfIdentificationDocument());
        self::assertSame('Something New', $fixture[0]->getStop());
        self::assertSame('Something New', $fixture[0]->getDateCreated());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();

        $originalNumObjectsInRepository = count($this->repository->findAll());

        $fixture = new Person();
        $fixture->setFirstName('My Title');
        $fixture->setLastName('My Title');
        $fixture->setCivility('My Title');
        $fixture->setNiu('My Title');
        $fixture->setDateOfBirth('My Title');
        $fixture->setPlaceOfBirth('My Title');
        $fixture->setFatherLastName('My Title');
        $fixture->setFatherFirstName('My Title');
        $fixture->setMotherFirstName('My Title');
        $fixture->setMotherLastName('My Title');
        $fixture->setEmail('My Title');
        $fixture->setPhone('My Title');
        $fixture->setTypeOfIdentificationDocument('My Title');
        $fixture->setIdentificationDocumentNumber('My Title');
        $fixture->setDateOfIssue('My Title');
        $fixture->setPictureFrontOfIdentificationDocument('My Title');
        $fixture->setPictureBackOfIdentificationDocument('My Title');
        $fixture->setStop('My Title');
        $fixture->setDateCreated('My Title');

        $this->repository->add($fixture, true);

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertSame($originalNumObjectsInRepository, count($this->repository->findAll()));
        self::assertResponseRedirects('/person/');
    }
}
